//
//  MCStackViewDefines.h
//  MCApplication
//
//  Created by Ali Lalani on 8/16/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

// MCStackView stuff
// sizing
extern float MCStackViewAnimationInterval;  // shoot for 30 fps
extern float MCStackViewAnimationDuration; // how long it takes to animate the view from start to finish
extern float MCStackViewAnimationDurationSlow;


// MCStackPane stuff
// sizing
extern float MCStackPaneMarginWidth; // how much space between the edges of the pane and the subviews contained within
												 // animation
extern float MCStackPaneBodyFadeDuration;
extern float MCStackPaneBodyFadeDurationSlow;
extern float MCStackPaneBodyFadeFrameRate;

// MCStackPaneHeader
extern float MCStackPaneHeaderHeight;
extern float MCStackPaneHeaderRoundedRectRadius;
extern float MCStackPaneHeaderButtonWidth;
extern float MCStackPaneHeaderButtonSpacing;

// MCStackTabbedHeader
extern NSColor *MCStackTabbedHeaderOffColor;
extern NSColor *MCStackTabbedHeaderOnColor;
extern NSColor *MCStackTabbedHeaderMouseDownColor;
extern NSColor *MCStackTabbedHeaderRolloverColor;

// MCStackResultsHeader
extern float MCStackResultsPaneTextArrowMargin;
extern float MCStackResultsPaneArrowWidth;
extern float MCStackResultsPaneArrowHeight;
extern float MCStackResultsPaneSearchFieldWidth;
extern float MCStackResultsPaneSearchFieldHeight;

// MCStackPaneBody
extern float MCStackPaneBodyInnerMargin;
extern NSColor *MCStackPaneBodyDefaultBackgroundColor;

// MCStackBrowseDetailView
extern float MCStackBrowseDetailViewTopMargin; // space between the top of the table view/text view and the top of the view

/////////////////////// NOTIFICATIONS ///////////////////

// Sent out when the selection changes in the results list(either the main or secondary tiers)
// includes MCResultsSelectedKey(array of arrays), MCWindowKey(the originating window)
extern NSString*  MCResultsSelectionDidChangeNotification;

// Notification userInfo Keys
extern NSString*  MCResultsSelectedKey;

@interface MCStackViewDefines : NSObject {
	
}
@end
